# Amber Finance Brand Kit

This brand kit contains all the official Amber Finance brand assets, logos, and visual identity elements.

## License

All Amber Finance brand assets are available under a Creative Commons Attribution-ShareAlike 4.0 International License (CC BY-SA 4.0).

## Usage Guidelines

### Primary Logos
- Use the primary Amber Finance logos for official communications and branding
- **logo-light.svg** and **logo-dark.svg**: Main brand logos
- **logo-claim-light.svg** and **logo-claim-dark.svg**: Logos with tagline

### Logo Grids
- Logo grids provide multiple logo variations in a single file for easy reference and comparison
- Icon grids contain icon variations and can be used for UI/UX design purposes

### Partner & Protocol Logos
- Partner logos should be used in accordance with their respective brand guidelines
- Protocol logos represent the underlying blockchain protocols and should be used appropriately in technical documentation

### Technical Specifications
- **Format**: Prefer SVG formats for web use, PNG for print materials where transparency is needed
- **Colors**: Maintain the original colors to preserve brand consistency
- **Minimum Size**: Ensure logos remain legible at their intended usage size

## File Organization

- `logos/`: Primary Amber Finance logos
- `logos-grids/`: Logo and icon grid variations
- `bitcoin-variants/`: Bitcoin-related protocol logos
- `protocols-infrastructure/`: Layer 1 and infrastructure protocol logos
- `partner-logos/`: Partner and protocol logos (organized by partner)
- `social-media/`: Social media assets (banners, avatars)
- `x-banners/`: Twitter banner variations
- `x-banner-deposits/`: Deposit-specific banner variations
- `additional-assets/`: Supplementary brand assets
- `favicons/`: Favicon and web app manifest files
- `fonts/`: Brand font files
- `audits/`: Security audit badges

## Attribution

When using these assets, please credit: "Amber Finance Brand Assets - CC BY-SA 4.0"

For more information, visit: https://docs.amberfinance.io/brand-kit

---
Generated on: 2025-12-10
